/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import settings.Settings;
import settings.SettingsListener;
import settings.SettingsOwner;

public class JUseClassSettingCheckbox
extends JCheckBox
implements SettingsListener,
ItemListener {
    private final SettingsOwner _opt_owner;
    private final String _opt_name;
    private final JComponent _c;

    public JUseClassSettingCheckbox(SettingsOwner opt_owner, String opt_name, JComponent c) {
        this.setToolTipText("Enables or disables if this option uses the default class setting.");
        this._opt_owner = opt_owner;
        this._opt_name = opt_name;
        this._c = c;
        this.update(Settings.uses_class_option(this._opt_owner, this._opt_name));
        Settings.register_obj_listener(this._opt_owner, this);
        this.addItemListener(this);
    }

    private void update(boolean use_class_setting) {
        this.setSelected(use_class_setting);
        if (this._c != null) {
            this._c.setEnabled(!use_class_setting);
        }
    }

    protected void finalize() throws Throwable {
        Settings.remove_obj_listener(this._opt_owner, this);
        super.finalize();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean use_class_setting;
        boolean bl = use_class_setting = e.getStateChange() == 1;
        if (use_class_setting) {
            Settings.unset_option(this._opt_owner, this._opt_name);
        }
        this.update(use_class_setting);
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        this.update(Settings.uses_class_option(this._opt_owner, this._opt_name));
    }
}

