/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Color;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import settings.JBoolOptionCheckbox;
import settings.JColorOption;
import settings.JDoubleOptionTextfield;
import settings.JEnumOptionComboBox;
import settings.JIntegerOptionTextfield;
import settings.JStringOptionTextfield;
import settings.JUseClassSettingCheckbox;
import settings.Settings;
import settings.SettingsOwner;

public class SettingsComponentFactory {
    private SettingsComponentFactory() {
    }

    public static final JCheckBox create_default_checkbox(SettingsOwner opt_owner, String opt_name, JComponent c) {
        return new JUseClassSettingCheckbox(opt_owner, opt_name, c);
    }

    public static final JComponent create_component(SettingsOwner owner, String opt_name) {
        Object opt = Settings.get_option(owner, opt_name);
        Class<?> opt_type = opt.getClass();
        JComponent comp = opt_type == Boolean.class ? new JBoolOptionCheckbox(owner, opt_name) : (opt_type == Integer.class ? new JIntegerOptionTextfield(owner, opt_name, 15) : (opt_type == Double.class ? new JDoubleOptionTextfield(owner, opt_name, 15) : (opt_type == String.class ? new JStringOptionTextfield(owner, opt_name) : (opt_type == Color.class ? new JColorOption(owner, opt_name) : (Enum.class.isInstance(opt) ? new JEnumOptionComboBox(owner, opt_name) : null)))));
        return comp;
    }

    public static final JComponent create_component(Class<?> opt_class, String opt_name) {
        JComponent comp;
        Object opt = Settings.get_class_option(opt_class, opt_name);
        Class<?> opt_type = opt.getClass();
        if (opt_type == Boolean.class) {
            comp = new JBoolOptionCheckbox(opt_class, opt_name);
        } else if (opt_type == Integer.class) {
            comp = new JIntegerOptionTextfield(opt_class, opt_name, 15);
        } else if (opt_type == Double.class) {
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMinimumFractionDigits(0);
            format.setMaximumFractionDigits(8);
            comp = new JDoubleOptionTextfield(opt_class, opt_name, 15, format);
        } else {
            comp = opt_type == String.class ? new JStringOptionTextfield(opt_class, opt_name) : (opt_type == Color.class ? new JColorOption(opt_class, opt_name) : (Enum.class.isInstance(opt) ? new JEnumOptionComboBox(opt_class, opt_name) : null));
        }
        return comp;
    }
}

