/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.JTFSlider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTFSliderInt
extends JTFSlider {
    private static final int DEF_COLS = 6;
    protected int _value;
    protected int _min;
    protected int _max;

    public JTFSliderInt(int orientation, int min, int max, int def) {
        super(orientation);
        this._min = min;
        this._max = max;
        this._value = def >= min && def <= max ? def : min + (max - min) / 2;
        this._jslider.setMinimum(min);
        this._jslider.setMaximum(max);
        this._jslider.setValue(this._value);
        this._jslider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int new_value = source.getValue();
                int old_value = JTFSliderInt.this._value;
                if (source.getValueIsAdjusting()) {
                    JTFSliderInt.this._value = new_value;
                    JTFSliderInt.this._jftf.setValue(JTFSliderInt.this._value);
                    JTFSliderInt.this.firePropertyChange(JTF_CHANGE, new Integer(old_value), new Integer(new_value));
                }
            }
        });
        this._formatter.setFormat(NumberFormat.getIntegerInstance());
        this._formatter.setMinimum(Integer.valueOf(min));
        this._formatter.setMaximum(Integer.valueOf(max));
        this._jftf.setValue(new Integer(this._value));
        this._jftf.setColumns(6);
        this._jftf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int new_value = (Integer)JTFSliderInt.this._jftf.getValue();
                int old_value = JTFSliderInt.this._value;
                JTFSliderInt.this._value = new_value;
                JTFSliderInt.this._jslider.setValue(new_value);
                JTFSliderInt.this.firePropertyChange(JTF_CHANGE, new Integer(old_value), new Integer(new_value));
            }
        });
        this._jftf.setInputVerifier(new MyTextFieldVerifier());
    }

    public JTFSliderInt(int min, int max, int def) {
        this(0, min, max, def);
    }

    @Override
    public JSlider get_slider() {
        return this._jslider;
    }

    @Override
    public JFormattedTextField get_ftf() {
        return this._jftf;
    }

    public int getValue() {
        return this._value;
    }

    public int getMinimum() {
        return this._min;
    }

    public int getMaximum() {
        return this._max;
    }

    public void setValue(int value) {
        if (value != this._value && this._min <= value && this._max >= value) {
            this._value = value;
            this._jslider.setValue(value);
            this._jftf.setValue(new Integer(value));
        }
    }

    public void setValueAndFireEvent(int value) {
        if (value != this._value && this._min <= value && this._max >= value) {
            int old_value = this._value;
            this._value = value;
            this._jslider.setValue(value);
            this._jftf.setValue(new Integer(value));
            this.firePropertyChange(JTF_CHANGE, new Integer(old_value), new Integer(value));
        }
    }

    public void setMinimum(int value) {
        this._min = value;
        this._jslider.setMinimum(value);
        this._formatter.setMinimum(Integer.valueOf(value));
    }

    public void setMaximum(int value) {
        this._max = value;
        this._jslider.setMaximum(value);
        this._formatter.setMaximum(Integer.valueOf(value));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._jslider.setEnabled(enabled);
        this._jftf.setEnabled(enabled);
    }

    private class MyTextFieldVerifier
    extends InputVerifier {
        private MyTextFieldVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean result;
            String text = JTFSliderInt.this._jftf.getText();
            try {
                Integer new_value = (Integer)JTFSliderInt.this._formatter.stringToValue(text);
                JTFSliderInt.this._value = new_value;
                result = true;
            }
            catch (Exception ex) {
                result = false;
            }
            return result;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            if (this.verify(input)) {
                JTFSliderInt.this._jslider.setValue(JTFSliderInt.this._value);
            }
            return true;
        }
    }
}

