/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Desktop;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MyHTMLPane
extends JEditorPane {
    public MyHTMLPane() {
        this.setContentType("text/html");
        this.setEditable(false);
        Color c = (Color)UIManager.get("Panel.background");
        if (c != null) {
            this.setBackground(c);
            this.setBorder(BorderFactory.createLineBorder(c, 5));
        }
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        URI uri = new URI(event.getDescription());
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                    }
                }
            }
        });
    }

    @Override
    public void setText(String text) {
        Color c = this.getBackground();
        String c_str = c != null ? " bgcolor=#" + Integer.toHexString(c.getRed()) + Integer.toHexString(c.getGreen()) + Integer.toHexString(c.getBlue()) : "";
        super.setText("<html><body" + c_str + ">" + text + "</body></html>");
    }
}

