/*
 * Decompiled with CFR 0.152.
 */
package main.launcher;

import gui.JTFSliderInt;
import gui.MyHTMLPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFrame;
import jgridmaker.GMPanel;
import main.launcher.LaunchYaDiV;

public class MemSetup {
    private static LogFileTarget _log_file_target = LogFileTarget.FILE;
    private static String MEM_LOG_FILE = new String("ymemlog.txt");
    private static JFrame _mem_dialog;
    public static String PREFS_MEM_XMS;
    public static String PREFS_MEM_XMX;
    public static String PREFS_MEM_SETUP_RUN;
    public static String PREFS_MEM_ERROR;
    public static int free_phys_memory_mb;
    public static int free_swap_space_mb;
    public static int total_mem_mb;

    static {
        PREFS_MEM_XMS = "XMS";
        PREFS_MEM_XMX = "XMX";
        PREFS_MEM_SETUP_RUN = "false";
        PREFS_MEM_ERROR = "Memory Error";
        free_phys_memory_mb = -1;
        free_swap_space_mb = -1;
        total_mem_mb = free_phys_memory_mb + free_swap_space_mb;
    }

    private static void get_memory_limits(PrintStream ps) {
        OperatingSystemMXBean os_mx_bean = ManagementFactory.getOperatingSystemMXBean();
        long free_phys_memory_bytes = -1L;
        long free_swap_space_bytes = -1L;
        ps.println("sun.arch.data.model = " + System.getProperty("sun.arch.data.model"));
        ps.println("OperatingSystemMXBean getters:");
        Method[] methodArray = os_mx_bean.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            method.setAccessible(true);
            if (method.getName().startsWith("get") && Modifier.isPublic(method.getModifiers())) {
                Object value;
                try {
                    value = method.invoke((Object)os_mx_bean, new Object[0]);
                }
                catch (Exception e) {
                    value = e;
                }
                if (value instanceof Long) {
                    Long lv = (Long)value;
                    lv = lv / 0x100000L;
                    ps.println(String.valueOf(method.getName()) + " = " + lv);
                } else {
                    ps.println(String.valueOf(method.getName()) + " = " + value);
                }
            }
            try {
                if (method.getName().equals("getFreePhysicalMemorySize")) {
                    free_phys_memory_bytes = (Long)method.invoke((Object)os_mx_bean, new Object[0]);
                }
                if (method.getName().equals("getFreeSwapSpaceSize")) {
                    free_swap_space_bytes = (Long)method.invoke((Object)os_mx_bean, new Object[0]);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        ps.flush();
        free_phys_memory_mb = (int)(free_phys_memory_bytes / 0x100000L);
        free_swap_space_mb = (int)(free_swap_space_bytes / 0x200000L);
        total_mem_mb = free_phys_memory_mb + free_swap_space_mb;
    }

    public static void setFixedWidth(Component component, int width) {
        component.setSize(new Dimension(width, Short.MAX_VALUE));
        Dimension preferredSize = component.getPreferredSize();
        component.setPreferredSize(new Dimension(width, preferredSize.height));
    }

    public static void show_mem_dialog() {
        _mem_dialog = new JFrame("YaDiV Setup");
        final Preferences prefs = Preferences.userRoot().node("YaDiV").node("MemSetup");
        _mem_dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        if (total_mem_mb == -1 || free_phys_memory_mb == -1) {
            MemSetup.init();
        }
        final JTFSliderInt jtfs_maxmem = new JTFSliderInt(0, total_mem_mb, free_phys_memory_mb);
        MyHTMLPane mhp_mem = new MyHTMLPane();
        JButton jb_start = new JButton("Start YaDiV");
        jb_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int xmx;
                int xms = xmx = jtfs_maxmem.getValue();
                prefs.putInt(PREFS_MEM_XMS, xms / 2);
                prefs.putInt(PREFS_MEM_XMX, xmx);
                prefs.putBoolean(PREFS_MEM_ERROR, false);
                prefs.putBoolean(PREFS_MEM_SETUP_RUN, true);
                _mem_dialog.setVisible(false);
                LaunchYaDiV.start_yadiv(xms, xmx);
                System.exit(0);
            }
        });
        String str = "";
        if (!prefs.getBoolean(PREFS_MEM_SETUP_RUN, false)) {
            str = "This dialog is shown as you run YaDiV for the first time on this computer. To change the memory setting again lateron, run MemSetup.jar\n\n";
        }
        str = String.valueOf(str) + "Choose how many memory YaDiV can access. More memory means that YaDiV will run faster and can open larger datasets. To free more memory, close other running programs that are not needed.\n";
        mhp_mem.setText(str);
        GMPanel gmp = new GMPanel();
        gmp.add("mhp_mem", mhp_mem);
        gmp.add("jtfs_maxmem", jtfs_maxmem);
        gmp.add("jb_start", jb_start);
        gmp.set_layout("<table>  <tr>    <td colspan='2'>::mhp_mem::</td>  </tr><tr>    <td width='99%' fill='horizontal'>::jtfs_maxmem::</td>    <td width='1%' anchor='west'>MB</td>  </tr><tr>    <td colspan='2'>::jb_start::</td>  </tr></table>");
        _mem_dialog.setLayout(new BorderLayout());
        _mem_dialog.add((Component)gmp, "Center");
        MemSetup.setFixedWidth(mhp_mem, 500);
        _mem_dialog.pack();
        _mem_dialog.setVisible(true);
    }

    public static void init() {
        PrintStream ps = null;
        if (_log_file_target == LogFileTarget.FILE) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(MEM_LOG_FILE);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            ps = new PrintStream(fos);
        } else {
            ps = System.out;
        }
        MemSetup.get_memory_limits(ps);
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            _log_file_target = LogFileTarget.STDOUT;
        }
        MemSetup.init();
        if (args.length == 0) {
            MemSetup.show_mem_dialog();
        }
    }

    public static enum LogFileTarget {
        STDOUT,
        FILE;

    }
}

