/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import settings.OptionWrapper;
import settings.SettingsListener;
import settings.SettingsOwner;

public final class Settings {
    public static String NEW_OBJ = "New Object";
    public static String DEL_OBJ = "Del Object";
    protected static HashMap<String, Class<?>> _class_name_map = new HashMap();
    protected static HashMap<Class<?>, HashMap<String, OptionWrapper>> _class_map = new HashMap();
    protected static HashMap<Class<?>, HashMap<String, String>> _opt_descr_map = new HashMap();
    protected static HashMap<String, HashMap<String, String>> _loaded_class_map = new HashMap();
    protected static Map<SettingsOwner, HashMap<String, OptionWrapper>> _obj_map = new WeakHashMap<SettingsOwner, HashMap<String, OptionWrapper>>();
    private static HashMap<Class<?>, LinkedList<SettingsListener>> _class_listener_map = new HashMap();
    private static HashMap<Class<?>, LinkedList<SettingsListener>> _obj_of_class_listener_map = new HashMap();
    private static Map<Class<?>, WeakHashMap<SettingsOwner, LinkedList<WeakReference<SettingsListener>>>> _obj_listener_map = new HashMap();

    private Settings() {
    }

    private static String register_opt(Class<?> opt_class, String opt_name, String opt_descr, Object opt) {
        HashMap<String, OptionWrapper> class_map = _class_map.get(opt_class);
        HashMap<String, String> opt_descr_map = _opt_descr_map.get(opt_class);
        HashMap<String, String> loaded_class_map = _loaded_class_map.get(opt_class.getSimpleName());
        OptionWrapper ow = new OptionWrapper(opt);
        if (class_map == null) {
            class_map = new HashMap();
            _class_map.put(opt_class, class_map);
            _class_name_map.put(opt_class.getSimpleName(), opt_class);
            opt_descr_map = new HashMap();
            _opt_descr_map.put(opt_class, opt_descr_map);
        }
        if (loaded_class_map != null && loaded_class_map.containsKey(opt_name)) {
            String opt_node_value = loaded_class_map.get(opt_name);
            ow.from_prefs_str(opt_node_value);
            if (ow._option != null) {
                class_map.put(opt_name, ow);
            }
            loaded_class_map.remove(opt_name);
        }
        if (Settings.get_class_option(opt_class, opt_name) == null) {
            ow = new OptionWrapper(opt);
            class_map.put(opt_name, ow);
        }
        opt_descr_map.put(opt_name, opt_descr);
        return opt_name;
    }

    public static String register_bool_opt(Class<?> opt_class, String opt_name, String opt_descr, Boolean bool_opt) {
        return Settings.register_opt(opt_class, opt_name, opt_descr, bool_opt);
    }

    public static String register_int_opt(Class<?> opt_class, String opt_name, String opt_descr, Integer int_opt) {
        return Settings.register_opt(opt_class, opt_name, opt_descr, int_opt);
    }

    public static String register_double_opt(Class<?> opt_class, String opt_name, String opt_descr, Double double_opt) {
        return Settings.register_opt(opt_class, opt_name, opt_descr, double_opt);
    }

    public static String register_str_opt(Class<?> opt_class, String opt_name, String opt_descr, String str_opt) {
        return Settings.register_opt(opt_class, opt_name, opt_descr, str_opt);
    }

    public static String register_color_opt(Class<?> opt_class, String opt_name, String opt_descr, Color color_opt) {
        return Settings.register_opt(opt_class, opt_name, opt_descr, color_opt);
    }

    public static String register_enum_opt(Class<?> opt_class, String opt_name, String opt_descr, Enum<?> enum_opt) {
        return Settings.register_opt(opt_class, opt_name, opt_descr, enum_opt);
    }

    private static void set_class_option(Class<?> opt_class, String opt_name, Object opt) {
        HashMap<String, OptionWrapper> class_map = _class_map.get(opt_class);
        OptionWrapper old_opt = class_map.get(opt_name);
        if (opt != null && !opt.equals(old_opt._option)) {
            old_opt._option = opt;
            Settings.notify_class_listeners(opt_class, opt_name, opt);
            Settings.notify_class_obj_listeners(opt_class, opt_name, opt);
        }
    }

    public static void set_class_bool_option(Class<?> opt_class, String opt_name, Boolean opt) {
        Settings.set_class_option(opt_class, opt_name, opt);
    }

    public static void set_class_int_option(Class<?> opt_class, String opt_name, Integer opt) {
        Settings.set_class_option(opt_class, opt_name, opt);
    }

    public static void set_class_double_option(Class<?> opt_class, String opt_name, Double opt) {
        Settings.set_class_option(opt_class, opt_name, opt);
    }

    public static void set_class_str_option(Class<?> opt_class, String opt_name, String opt) {
        Settings.set_class_option(opt_class, opt_name, opt);
    }

    public static void set_class_color_option(Class<?> opt_class, String opt_name, Color opt) {
        Settings.set_class_option(opt_class, opt_name, opt);
    }

    public static void set_class_enum_option(Class<?> opt_class, String opt_name, Enum<?> opt) {
        Settings.set_class_option(opt_class, opt_name, opt);
    }

    private static void set_option(SettingsOwner obj, String opt_name, Object opt) {
        HashMap<String, OptionWrapper> obj_map = _obj_map.get(obj);
        Object old_opt = obj_map.get((Object)opt_name)._option;
        if (opt == null && old_opt != null || opt != null && !opt.equals(old_opt)) {
            obj_map.put(opt_name, new OptionWrapper(opt));
            Settings.notify_obj_listeners(obj, opt_name, opt);
            Settings.notify_obj_of_class_listeners(obj, opt_name, opt);
        }
    }

    public static void set_bool_option(SettingsOwner obj, String opt_name, Boolean opt) {
        Settings.set_option(obj, opt_name, opt);
    }

    public static void set_int_option(SettingsOwner obj, String opt_name, Integer opt) {
        Settings.set_option(obj, opt_name, opt);
    }

    public static void set_double_option(SettingsOwner obj, String opt_name, Double opt) {
        Settings.set_option(obj, opt_name, opt);
    }

    public static void set_str_option(SettingsOwner obj, String opt_name, String opt) {
        Settings.set_option(obj, opt_name, opt);
    }

    public static void set_color_option(SettingsOwner obj, String opt_name, Color opt) {
        Settings.set_option(obj, opt_name, opt);
    }

    public static void set_enum_option(SettingsOwner obj, String opt_name, Enum<?> opt) {
        Settings.set_option(obj, opt_name, opt);
    }

    public static void unset_option(SettingsOwner obj, String opt_name) {
        HashMap<String, OptionWrapper> class_map = _class_map.get(obj.getClass());
        HashMap<String, OptionWrapper> object_map = _obj_map.get(obj);
        if (object_map != null) {
            object_map.put(opt_name, class_map.get(opt_name));
            Settings.notify_obj_listeners(obj, opt_name, Settings.get_class_option(obj.getClass(), opt_name));
        }
    }

    protected static Object get_class_option(Class<?> opt_class, String opt_name) {
        OptionWrapper ow;
        HashMap<String, OptionWrapper> class_map = _class_map.get(opt_class);
        Object result = null;
        if (class_map != null && (ow = class_map.get(opt_name)) != null) {
            result = ow._option;
        }
        return result;
    }

    public static boolean uses_class_option(SettingsOwner obj, String opt_name) {
        HashMap<String, OptionWrapper> class_map = _class_map.get(obj.getClass());
        HashMap<String, OptionWrapper> object_map = _obj_map.get(obj);
        return class_map.get(opt_name) == object_map.get(opt_name);
    }

    protected static Object get_option(Object obj, String opt_name) {
        Object result = null;
        if (obj.getClass() == Class.class) {
            result = Settings.get_class_option((Class)obj, opt_name);
        } else {
            HashMap<String, OptionWrapper> obj_map = _obj_map.get(obj);
            result = obj_map.get((Object)opt_name)._option;
        }
        return result;
    }

    public static Boolean get_bool_option(Object obj, String opt_name) {
        return (Boolean)Settings.get_option(obj, opt_name);
    }

    public static Integer get_int_option(Object obj, String opt_name) {
        return (Integer)Settings.get_option(obj, opt_name);
    }

    public static Double get_double_option(Object obj, String opt_name) {
        return (Double)Settings.get_option(obj, opt_name);
    }

    public static String get_str_option(Object obj, String opt_name) {
        return (String)Settings.get_option(obj, opt_name);
    }

    public static Color get_color_option(Object obj, String opt_name) {
        return (Color)Settings.get_option(obj, opt_name);
    }

    public static Enum<?> get_enum_option(Object obj, String opt_name) {
        return (Enum)Settings.get_option(obj, opt_name);
    }

    public static void register_class_listener(Class<?> opt_class, SettingsListener l) {
        LinkedList<SettingsListener> class_listeners = _class_listener_map.get(opt_class);
        if (class_listeners == null) {
            class_listeners = new LinkedList();
            _class_listener_map.put(opt_class, class_listeners);
        }
        class_listeners.add(l);
    }

    public static void register_all_objs_of_class_listener(Class<?> opt_class, SettingsListener l) {
        LinkedList<SettingsListener> obj_of_class_listeners = _obj_of_class_listener_map.get(opt_class);
        if (obj_of_class_listeners == null) {
            obj_of_class_listeners = new LinkedList();
            _obj_of_class_listener_map.put(opt_class, obj_of_class_listeners);
        }
        obj_of_class_listeners.add(l);
    }

    public static void register_obj_listener(SettingsOwner owner, SettingsListener l) {
        LinkedList<WeakReference<SettingsListener>> obj_listeners;
        WeakHashMap<SettingsOwner, LinkedList<WeakReference<SettingsListener>>> owner_map = _obj_listener_map.get(owner.getClass());
        if (owner_map == null) {
            owner_map = new WeakHashMap();
            _obj_listener_map.put(l.getClass(), owner_map);
        }
        if ((obj_listeners = owner_map.get(owner)) == null) {
            obj_listeners = new LinkedList();
            owner_map.put(owner, obj_listeners);
        }
        obj_listeners.add(new WeakReference<SettingsListener>(l));
    }

    public static void register_owner(SettingsOwner owner) {
        HashMap<String, OptionWrapper> owner_map = _obj_map.get(owner);
        if (owner_map == null) {
            HashMap<String, OptionWrapper> class_options = _class_map.get(owner.getClass());
            Set<String> opt_names = class_options.keySet();
            owner_map = new HashMap();
            for (String opt_name : opt_names) {
                owner_map.put(opt_name, class_options.get(opt_name));
            }
            _obj_map.put(owner, owner_map);
            Settings.notify_class_listeners(Settings.class, NEW_OBJ, owner);
        } else {
            System.err.println("Settings: unhandeld case of registering an owner twice");
        }
        Settings.register_obj_listener(owner, owner);
    }

    public static void unregister_owner(SettingsOwner owner) {
        Map owner_map = _obj_listener_map.get(owner.getClass());
        if (owner_map != null) {
            Settings.notify_class_listeners(Settings.class, DEL_OBJ, owner);
            _obj_listener_map.remove(owner);
            _obj_map.remove(owner);
        }
    }

    public static void remove_class_listener(Class<?> opt_class, SettingsListener l) {
        LinkedList<SettingsListener> class_listeners = _class_listener_map.get(opt_class);
        if (class_listeners != null) {
            class_listeners.remove(l);
        }
    }

    public static void remove_obj_listener(SettingsOwner owner, SettingsListener l) {
        Map owner_map = _obj_listener_map.get(owner.getClass());
        if (owner_map != null) {
            LinkedList obj_listeners = (LinkedList)owner_map.get(owner);
            Iterator i = obj_listeners.iterator();
            while (i.hasNext()) {
                SettingsListener referent = (SettingsListener)((WeakReference)i.next()).get();
                if (referent != null && referent != l) continue;
                i.remove();
            }
        }
    }

    public static void remove_all_objs_of_class_listener(Class<?> opt_class, SettingsListener l) {
        LinkedList<SettingsListener> obj_of_class_listeners = _obj_of_class_listener_map.get(opt_class);
        if (obj_of_class_listeners != null) {
            obj_of_class_listeners.remove(l);
        }
    }

    private static void notify_class_listeners(Class<?> opt_class, String opt_name, Object opt) {
        Iterator sli;
        LinkedList<SettingsListener> class_listeners = _class_listener_map.get(opt_class);
        if (opt_class != Settings.class && class_listeners != null) {
            sli = class_listeners.iterator();
            while (sli.hasNext()) {
                ((SettingsListener)sli.next()).settings_changed(opt_class, opt_name, opt);
            }
        }
        if ((class_listeners = _class_listener_map.get(Settings.class)) != null) {
            sli = class_listeners.iterator();
            while (sli.hasNext()) {
                ((SettingsListener)sli.next()).settings_changed(opt_class, opt_name, opt);
            }
        }
    }

    private static void notify_class_obj_listeners(Class<?> opt_class, String opt_name, Object opt) {
        Map owner_map = _obj_listener_map.get(opt_class);
        if (owner_map != null) {
            Set owner_set = owner_map.keySet();
            for (SettingsOwner so : owner_set) {
                if (!Settings.uses_class_option(so, opt_name)) continue;
                LinkedList obj_listeners = (LinkedList)owner_map.get(so);
                Iterator sli = obj_listeners.iterator();
                while (sli.hasNext()) {
                    SettingsListener referent = (SettingsListener)((WeakReference)sli.next()).get();
                    if (referent == null) {
                        sli.remove();
                        continue;
                    }
                    referent.settings_changed(so, opt_name, opt);
                }
            }
        }
    }

    private static void notify_obj_of_class_listeners(SettingsOwner owner, String opt_name, Object opt) {
        Class<?> opt_class = owner.getClass();
        LinkedList<SettingsListener> obj_of_class_listeners = _obj_of_class_listener_map.get(opt_class);
        if (obj_of_class_listeners != null) {
            Iterator sli = obj_of_class_listeners.iterator();
            while (sli.hasNext()) {
                ((SettingsListener)sli.next()).settings_changed(owner, opt_name, opt);
            }
        }
    }

    private static void notify_obj_listeners(SettingsOwner obj, String opt_name, Object opt) {
        LinkedList<WeakReference<SettingsListener>> obj_listeners = _obj_listener_map.get(obj.getClass()).get(obj);
        if (obj_listeners != null) {
            Iterator sli = obj_listeners.iterator();
            while (sli.hasNext()) {
                SettingsListener referent = (SettingsListener)((WeakReference)sli.next()).get();
                if (referent == null) {
                    sli.remove();
                    continue;
                }
                referent.settings_changed(obj, opt_name, opt);
            }
        }
    }

    public static boolean load(String unique_id) {
        Preferences y_prefs = Preferences.userRoot().node(unique_id).node("Settings");
        try {
            String[] class_node_names = y_prefs.childrenNames();
            int i = 0;
            while (i < class_node_names.length) {
                String class_node_name = class_node_names[i];
                HashMap<String, String> loaded_class_map = new HashMap<String, String>();
                Preferences class_prefs = y_prefs.node(class_node_name);
                String[] opt_node_names = class_prefs.keys();
                Class<?> opt_class = _class_name_map.get(class_node_name);
                int j = 0;
                while (j < opt_node_names.length) {
                    String opt_node_name = opt_node_names[j];
                    String opt_node_value = class_prefs.get(opt_node_name, "---");
                    if (opt_class != null && _class_map.containsKey(opt_class) && _class_map.get(opt_class).containsKey(opt_node_name)) {
                        OptionWrapper ow = _class_map.get(opt_class).get(opt_node_name);
                        ow.from_prefs_str(opt_node_value);
                    } else {
                        loaded_class_map.put(opt_node_name, opt_node_value);
                    }
                    ++j;
                }
                _loaded_class_map.put(class_node_name, loaded_class_map);
                ++i;
            }
            System.out.println("Settings loaded");
            return true;
        }
        catch (BackingStoreException ex) {
            System.err.println("Settings: could not load preferences");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }

    public static void save(String unique_id) {
        Set<Class<?>> class_set = _class_map.keySet();
        Preferences y_prefs = Preferences.userRoot().node(unique_id).node("Settings");
        for (Class<?> current_class : class_set) {
            Preferences prefs = y_prefs.node(current_class.getSimpleName());
            HashMap<String, OptionWrapper> current_class_options = _class_map.get(current_class);
            Set<String> option_names_set = current_class_options.keySet();
            for (String option_key_str : option_names_set) {
                OptionWrapper option_value = current_class_options.get(option_key_str);
                prefs.put(option_key_str, option_value.to_prefs_str());
            }
        }
    }

    public static void reset() {
    }

    public static String get_descr(Class<?> opt_class, String opt_name) {
        return _opt_descr_map.get(opt_class).get(opt_name);
    }
}

