/*
 * Decompiled with CFR 0.152.
 */
package net.jcores;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.jcores.CoreKeeper;
import net.jcores.cores.CoreNumber;
import net.jcores.interfaces.functions.F0;
import net.jcores.managers.Manager;
import net.jcores.managers.ManagerClass;
import net.jcores.managers.ManagerDebugGUI;
import net.jcores.managers.ManagerStatistics;
import net.jcores.options.MessageType;
import net.jcores.options.Option;
import net.jcores.utils.Reporter;

public class CommonCore {
    private final ExecutorService executor;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Reporter reporter = new Reporter();
    private final ConcurrentMap<Class<? extends Manager>, Manager> managers = new ConcurrentHashMap<Class<? extends Manager>, Manager>();
    private final Random random = new Random();

    CommonCore() {
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.manager(ManagerClass.class, new ManagerClass());
        this.manager(ManagerStatistics.class, new ManagerStatistics());
        this.manager(ManagerDebugGUI.class, new ManagerDebugGUI());
    }

    public Integer[] box(int ... object) {
        int i = 0;
        Integer[] myIntegers = new Integer[object.length];
        int[] nArray = object;
        int n = object.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            myIntegers[i++] = val;
            ++n2;
        }
        return myIntegers;
    }

    public void edt(final F0 f0) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                f0.f();
            }
        });
    }

    public void edtnow(final F0 f0) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    f0.f();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void execute(Runnable r, int count) {
        int i = 0;
        while (i < count) {
            this.executor.execute(r);
            ++i;
        }
    }

    public <T extends Manager> T manager(Class<T> clazz, T manager) {
        this.managers.putIfAbsent(clazz, manager);
        return (T)((Manager)this.managers.get(clazz));
    }

    public <T extends Manager> T manager(Class<T> clazz) {
        return (T)((Manager)this.managers.get(clazz));
    }

    public void log(String string, Level level) {
        this.logger.log(level, string);
    }

    public void oneTime(final F0 f0, long delay) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                f0.f();
            }
        }, delay);
    }

    public CoreNumber range(int end) {
        return this.range(0, end, 1);
    }

    public CoreNumber range(int from, int end) {
        return this.range(from, end, from <= end ? 1 : -1);
    }

    public CoreNumber range(int from, int end, int stepping) {
        int[] rval = new int[Math.abs((end - from) / stepping)];
        int ptr = 0;
        if (from <= end) {
            int i = from;
            while (i < end) {
                rval[ptr++] = i;
                i += stepping;
            }
        } else {
            int i = from;
            while (i > end) {
                rval[ptr++] = i;
                i += stepping;
            }
        }
        return CoreKeeper.$(this.box(rval));
    }

    public void report(MessageType type, String problem) {
        this.reporter.record(problem);
    }

    public void report() {
        this.reporter.printRecords();
    }

    public Random random() {
        return this.random;
    }

    public boolean sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            return true;
        }
        return false;
    }

    public File tempfile() {
        try {
            return File.createTempFile("jcores.", ".tmp");
        }
        catch (IOException iOException) {
            return new File("/tmp/jcores.failedtmp." + System.nanoTime() + ".tmp");
        }
    }

    public File tempdir() {
        File file = new File(this.tempfile().getAbsoluteFile() + ".dir/");
        file.mkdirs();
        return file;
    }

    public int[] unbox(Integer ... object) {
        int i = 0;
        int[] myIntegers = new int[object.length];
        Integer[] integerArray = object;
        int n = object.length;
        int n2 = 0;
        while (n2 < n) {
            int val = integerArray[n2];
            myIntegers[i++] = val;
            ++n2;
        }
        return myIntegers;
    }

    public String uniqueID(Option ... options) {
        return UUID.randomUUID().toString();
    }
}

