/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.jcores.CommonCore;
import net.jcores.CoreKeeper;
import net.jcores.cores.CoreByteBuffer;
import net.jcores.cores.CoreObject;
import net.jcores.interfaces.functions.F1;
import net.jcores.managers.ManagerClass;
import net.jcores.options.MessageType;
import net.jcores.options.Option;
import net.jcores.utils.io.StreamUtils;

public class CoreClass<T>
extends CoreObject<Class<T>> {
    private static final long serialVersionUID = -5054890786513339808L;
    protected final ManagerClass manager;
    protected final Map<Class<?>[], Constructor<T>> constructors = new HashMap<Class<?>[], Constructor<T>>();

    public CoreClass(CommonCore supercore, Class<T> ... clazzes) {
        super(supercore, clazzes);
        this.manager = supercore.manager(ManagerClass.class);
    }

    public CoreByteBuffer bytecode() {
        return new CoreByteBuffer(this.commonCore, this.map(new F1<Class<T>, ByteBuffer>(){

            @Override
            public ByteBuffer f(Class<T> x) {
                String classname = String.valueOf(x.getCanonicalName().replaceAll("\\.", "/")) + ".class";
                ClassLoader classloader = x.getClassLoader();
                if (classloader == null) {
                    CoreClass.this.commonCore.report(MessageType.EXCEPTION, "Could not get classloader for " + x);
                    return null;
                }
                return StreamUtils.getByteData(classloader.getResourceAsStream(classname));
            }
        }, new Option[0]).array(ByteBuffer.class));
    }

    public CoreObject<T> spawn(final Object ... args) {
        return this.map(new F1<Class<T>, T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T f(Class<T> x) {
                if (x == null) {
                    return null;
                }
                Class<Object> toSpawn = x;
                if (x.isInterface()) {
                    toSpawn = CoreClass.this.manager.getImplementors(x)[0];
                }
                if (args == null || args.length == 0) {
                    try {
                        return CoreClass.this.manager.registerObject(x, toSpawn.newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                Class[] types = CoreKeeper.$(args).map(new F1<Object, Class<?>>(){

                    @Override
                    public Class<?> f(Object xx) {
                        return xx.getClass();
                    }
                }, new Option[0]).array(Class.class);
                try {
                    Constructor<Object> constructor = null;
                    Map map = CoreClass.this.constructors;
                    synchronized (map) {
                        constructor = CoreClass.this.constructors.get(types);
                        if (constructor == null) {
                            constructor = toSpawn.getConstructor(types);
                            CoreClass.this.constructors.put(types, constructor);
                        }
                    }
                    return CoreClass.this.manager.registerObject(x, constructor.newInstance(args));
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, new Option[0]);
    }

    public void implementor(Class<?> implemenetor) {
        Class clazz;
        if (this.size() > 1) {
            this.commonCore.report(MessageType.MISUSE, "implementor() should not be used on cores with more than one class!");
        }
        if ((clazz = (Class)this.get(null)) == null) {
            return;
        }
        this.manager.registerImplementor(clazz, implemenetor);
    }

    public CoreObject<T> spawned() {
        if (this.get(null) == null) {
            return new CoreObject<Object>(this.commonCore, new Object[0]);
        }
        return new CoreObject(this.commonCore, this.manager.getAllObjectsFor((Class)this.get(false)));
    }
}

