/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.ZipInputStream;
import net.jcores.CommonCore;
import net.jcores.CoreKeeper;
import net.jcores.cores.CoreByteBuffer;
import net.jcores.cores.CoreObject;
import net.jcores.cores.CoreString;
import net.jcores.cores.CoreZipInputStream;
import net.jcores.interfaces.functions.F1;
import net.jcores.options.MessageType;
import net.jcores.options.Option;
import net.jcores.options.OptionHash;
import net.jcores.utils.io.StreamUtils;

public class CoreInputStream
extends CoreObject<InputStream> {
    private static final long serialVersionUID = 1520313333781137198L;

    public CoreInputStream(CommonCore supercore, InputStream ... objects) {
        super(supercore, objects);
    }

    public void close() {
        int i = 0;
        while (i < this.size()) {
            InputStream inputStream = (InputStream)this.get(i);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.commonCore.report(MessageType.EXCEPTION, "Error closing stream " + inputStream + ".");
            }
            ++i;
        }
    }

    public <T> CoreObject<T> deserialize(Class<T> type, Option ... options) {
        CoreObject<T> core;
        if (this.size() > 1) {
            this.commonCore.report(MessageType.MISUSE, "deserialize() should not be used on cores with more than one class!");
        }
        if ((core = StreamUtils.deserializeCore(type, (InputStream)this.get(false))) != null) {
            core.commonCore = this.commonCore;
            return core;
        }
        return new CoreObject<Object>(this.commonCore, type, null);
    }

    public void unzip(final String destination) {
        this.map(new F1<InputStream, Void>(){

            @Override
            public Void f(InputStream x) {
                try {
                    StreamUtils.doUnzip(x, destination);
                    x.close();
                }
                catch (IOException e) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "IO error processing " + x + ".");
                }
                return null;
            }
        }, new Option[0]);
    }

    public CoreZipInputStream zipstream() {
        return this.map(new F1<InputStream, ZipInputStream>(){

            @Override
            public ZipInputStream f(InputStream x) {
                return new ZipInputStream(x);
            }
        }, new Option[0]).as(CoreZipInputStream.class);
    }

    public CoreString text() {
        return new CoreString(this.commonCore, this.map(new F1<InputStream, String>(){

            @Override
            public String f(InputStream x) {
                String readText = StreamUtils.readText(CoreInputStream.this.commonCore, x);
                try {
                    x.close();
                }
                catch (IOException e) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "Error closing stream " + x + ".");
                }
                return readText;
            }
        }, new Option[0]).array(String.class));
    }

    public CoreString hash(Option ... options) {
        final String method = ((OptionHash)CoreKeeper.$(options).get(OptionHash.class, Option.HASH_MD5)).getMethod();
        return new CoreString(this.commonCore, this.map(new F1<InputStream, String>(){

            @Override
            public String f(InputStream x) {
                String generateHash = StreamUtils.generateHash(x, method);
                try {
                    x.close();
                }
                catch (IOException e) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "Error closing stream " + x + ".");
                }
                return generateHash;
            }
        }, new Option[0]).array(String.class));
    }

    public CoreByteBuffer data() {
        return new CoreByteBuffer(this.commonCore, this.map(new F1<InputStream, ByteBuffer>(){

            @Override
            public ByteBuffer f(InputStream x) {
                ByteBuffer byteData = StreamUtils.getByteData(x);
                try {
                    x.close();
                }
                catch (IOException e) {
                    CoreInputStream.this.commonCore.report(MessageType.EXCEPTION, "Error closing stream " + x + ".");
                }
                return byteData;
            }
        }, new Option[0]).array(ByteBuffer.class));
    }
}

