/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import net.jcores.CommonCore;
import net.jcores.cores.CoreObject;

public class CoreNumber
extends CoreObject<Number> {
    private static final long serialVersionUID = -8437925527295825364L;

    public CoreNumber(CommonCore supercore, Number ... objects) {
        super(supercore, objects);
    }

    public double average() {
        int size = this.size();
        int cnt = 0;
        double sum = 0.0;
        int i = 0;
        while (i < size) {
            Number number = this.get(i);
            if (number != null) {
                sum += number.doubleValue();
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            return 0.0;
        }
        return sum / (double)cnt;
    }

    public double variance() {
        double average = this.average();
        int size = this.size();
        int cnt = 0;
        double rval = 0.0;
        int i = 0;
        while (i < size) {
            Number number = this.get(i);
            if (number != null) {
                rval += (average - number.doubleValue()) * (average - number.doubleValue());
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            return 0.0;
        }
        return rval / (double)cnt;
    }

    public double standarddeviation() {
        return Math.sqrt(this.variance());
    }

    public double sum() {
        int size = this.size();
        double sum = 0.0;
        int i = 0;
        while (i < size) {
            Number number = this.get(i);
            if (number != null) {
                sum += number.doubleValue();
            }
            ++i;
        }
        return sum;
    }
}

