/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import net.jcores.CommonCore;
import net.jcores.CoreKeeper;
import net.jcores.cores.CoreFile;
import net.jcores.cores.CoreInputStream;
import net.jcores.cores.CoreObject;
import net.jcores.interfaces.functions.F1;
import net.jcores.options.MessageType;
import net.jcores.options.Option;
import net.jcores.utils.io.StreamUtils;

public class CoreURI
extends CoreObject<URI> {
    private static final long serialVersionUID = 7366734773387957013L;

    public CoreURI(CommonCore supercore, URI ... objects) {
        super(supercore, objects);
    }

    public CoreInputStream input() {
        return new CoreInputStream(this.commonCore, this.map(new F1<URI, InputStream>(){

            @Override
            public InputStream f(URI x) {
                try {
                    URL url = x.toURL();
                    InputStream openStream = url.openStream();
                    return openStream;
                }
                catch (MalformedURLException e) {
                    CoreURI.this.commonCore.report(MessageType.EXCEPTION, "URI " + x + " could not be transformed into an URL.");
                }
                catch (IOException e) {
                    CoreURI.this.commonCore.report(MessageType.EXCEPTION, "URI " + x + " could not be opened for reading.");
                }
                return null;
            }
        }, new Option[0]).array(InputStream.class));
    }

    public CoreFile download() {
        return new CoreFile(this.commonCore, this.map(new F1<URI, File>(){

            @Override
            public File f(URI x) {
                try {
                    URL url = x.toURL();
                    InputStream openStream = url.openStream();
                    File file = File.createTempFile("jcores.download.", ".tmp");
                    StreamUtils.saveTo(openStream, file);
                    openStream.close();
                    return file;
                }
                catch (MalformedURLException e) {
                    CoreURI.this.commonCore.report(MessageType.EXCEPTION, "URI " + x + " could not be transformed into an URL.");
                }
                catch (IOException e) {
                    CoreURI.this.commonCore.report(MessageType.EXCEPTION, "URI " + x + " could not be opened for reading.");
                }
                return null;
            }
        }, new Option[0]).array(File.class));
    }

    public CoreFile download(final String path) {
        return new CoreFile(this.commonCore, this.map(new F1<URI, File>(){

            @Override
            public File f(URI x) {
                try {
                    String filepath = (String)CoreKeeper.$(x.getPath()).split("/").get(-1);
                    URL url = x.toURL();
                    InputStream openStream = url.openStream();
                    File file = new File(String.valueOf(path) + "/" + filepath);
                    StreamUtils.saveTo(openStream, file);
                    openStream.close();
                    return file;
                }
                catch (MalformedURLException e) {
                    CoreURI.this.commonCore.report(MessageType.EXCEPTION, "URI " + x + " could not be transformed into an URL.");
                }
                catch (IOException e) {
                    CoreURI.this.commonCore.report(MessageType.EXCEPTION, "URI " + x + " could not be opened for reading.");
                }
                return null;
            }
        }, new Option[0]).array(File.class));
    }

    public CoreFile file() {
        return new CoreFile(this.commonCore, this.map(new F1<URI, File>(){

            @Override
            public File f(URI x) {
                try {
                    return new File(x);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }, new Option[0]).array(File.class));
    }
}

