/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipInputStream;
import net.jcores.CommonCore;
import net.jcores.cores.CoreObject;
import net.jcores.cores.CoreString;
import net.jcores.interfaces.functions.F1;
import net.jcores.options.MessageType;
import net.jcores.options.Option;
import net.jcores.utils.io.InputStreamWrapper;
import net.jcores.utils.io.StreamUtils;

public class CoreZipInputStream
extends CoreObject<ZipInputStream> {
    private static final long serialVersionUID = 5934382074823292082L;
    private boolean multipleGet = false;

    public CoreZipInputStream(CommonCore supercore, ZipInputStream ... objects) {
        super(supercore, objects);
    }

    public CoreZipInputStream unzip(final String destination) {
        this.map(new F1<ZipInputStream, Void>(){

            @Override
            public Void f(ZipInputStream x) {
                try {
                    StreamUtils.doUnzip(x, destination);
                    x.close();
                }
                catch (IOException e) {
                    CoreZipInputStream.this.commonCore.report(MessageType.EXCEPTION, "IO error processing " + e + ".");
                }
                return null;
            }
        }, new Option[0]);
        return this;
    }

    public CoreString dir() {
        return this.map(new F1<ZipInputStream, List<String>>(){

            @Override
            public List<String> f(ZipInputStream x) {
                try {
                    List<String> list = StreamUtils.list(x);
                    x.close();
                    return list;
                }
                catch (IOException e) {
                    CoreZipInputStream.this.commonCore.report(MessageType.EXCEPTION, "IO error processing " + e + ".");
                    return null;
                }
            }
        }, new Option[0]).expand(String.class).as(CoreString.class);
    }

    @Override
    public InputStream get(String path) {
        ZipInputStream zipInputStream;
        if (this.multipleGet) {
            this.commonCore.report(MessageType.MISUSE, "You must not call get() on a ZipStream multiple times! Latter calls might fail. Check the documentation.");
        }
        if ((zipInputStream = (ZipInputStream)this.get(false)) == null) {
            return null;
        }
        try {
            final InputStream inputStream = StreamUtils.getInputStream(zipInputStream, path);
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream){

                @Override
                public void close() throws IOException {
                    super.close();
                    inputStream.close();
                }
            };
            return inputStreamWrapper;
        }
        catch (IOException iOException) {
        }
        finally {
            this.multipleGet = true;
        }
        return null;
    }
}

