/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.utils;

import java.util.HashMap;
import java.util.Set;

public class Compound
extends HashMap<String, Object> {
    private static final long serialVersionUID = 6962084609409112972L;

    public static Compound create(Object ... objects) {
        Compound rval = new Compound();
        if (objects == null || objects.length < 2 || objects.length % 2 != 0) {
            return rval;
        }
        String key = null;
        int i = 0;
        while (i < objects.length) {
            if (i % 2 == 0) {
                key = (String)objects[i];
            } else {
                rval.put(key, objects[i]);
            }
            ++i;
        }
        return rval;
    }

    public int getInt(String key) {
        Object object = this.get(key);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        return object.hashCode();
    }

    public String getString(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public double getDouble(String key) {
        Object object = this.get(key);
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object.hashCode();
    }

    @Override
    public void put(String key, int value) {
        this.put(key, Integer.valueOf(value));
    }

    @Override
    public void put(String key, double value) {
        this.put(key, Double.valueOf(value));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        Set keySet = this.keySet();
        for (String string : keySet) {
            sb.append(string);
            sb.append(":");
            sb.append(this.get(string));
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }
}

