/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.utils.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jcores.CommonCore;
import net.jcores.CoreKeeper;
import net.jcores.options.MessageType;
import net.jcores.options.Option;

public class FileUtils {
    public static String readText(CommonCore cc, File file) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            cc.report(MessageType.EXCEPTION, "File not found " + file);
        }
        catch (IOException e) {
            cc.report(MessageType.EXCEPTION, "Error reading from file " + file);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    cc.report(MessageType.EXCEPTION, "Error closing file " + file);
                }
            }
        }
        return null;
    }

    public static void copy(CommonCore cc, File from, File to) {
        block22: {
            boolean todir;
            boolean bl = todir = to.getAbsolutePath().endsWith("/") || to.isDirectory();
            if (todir) {
                to.mkdirs();
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                try {
                    fis = new FileInputStream(from);
                    fos = new FileOutputStream(todir ? new File(to.getAbsoluteFile() + "/" + from.getName()) : to);
                    byte[] buf = new byte[65536];
                    int i = 0;
                    while ((i = fis.read(buf)) != -1) {
                        fos.write(buf, 0, i);
                    }
                }
                catch (Exception e) {
                    cc.report(MessageType.EXCEPTION, "Error copying file " + from + " " + to + " due to a " + e.getMessage());
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fos == null) break block22;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void zipFiles(File target, File[] t) {
        byte[] buffer = new byte[32768];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(target));
            File[] fileArray = t;
            int n = t.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                File[] toStore = file.isDirectory() ? CoreKeeper.$(file).dir(new Option[0]).array(File.class) : CoreKeeper.$(file).array(File.class);
                String absolute = file.getAbsolutePath();
                File[] fileArray2 = toStore;
                int n3 = toStore.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file2 = fileArray2[n4];
                    String entryname = file.isDirectory() ? file2.getAbsolutePath().substring(absolute.length() + 1) : file2.getName();
                    try {
                        int bytesRead;
                        FileInputStream in = new FileInputStream(file2);
                        ZipEntry entry = new ZipEntry(entryname);
                        out.putNextEntry(entry);
                        while ((bytesRead = in.read(buffer)) != -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                        in.close();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n4;
                }
                ++n2;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

