/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.loader;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.configuration.ConfigurationFile;
import net.xeoh.plugins.base.annotations.configuration.IsDisabled;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.ClassPathManager;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.impl.registry.PluginClassMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluginMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluginRegistry;
import net.xeoh.plugins.base.impl.spawning.SpawnResult;
import net.xeoh.plugins.base.impl.spawning.Spawner;
import net.xeoh.plugins.base.options.getplugin.OptionCapabilities;
import net.xeoh.plugins.base.util.PluginConfigurationUtil;

public abstract class AbstractLoader {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final PluginManagerImpl pluginManager;

    public AbstractLoader(PluginManagerImpl pluginManager) {
        this.pluginManager = pluginManager;
    }

    public abstract boolean handlesURI(URI var1);

    public abstract void loadFrom(URI var1);

    protected void tryToLoadClassAsPlugin(AbstractClassPathLocation location, String name) {
        this.logger.finest("Trying to load " + name + " as a plugin.");
        ClassPathManager classPathManager = this.pluginManager.getClassPathManager();
        PluginRegistry pluginRegistry = this.pluginManager.getPluginRegistry();
        PluginConfigurationUtil pcu = new PluginConfigurationUtil(this.pluginManager.getPluginConfiguration());
        Spawner spawner = this.pluginManager.getSpawner();
        try {
            String properties;
            Class<?> possiblePlugin = classPathManager.loadClass(location, name);
            if (name.startsWith("net.xeoh.plugins.base") || name.startsWith("net.xeoh.plugins.diagnosis.") || name.startsWith("net.xeoh.plugins.informationbroker.")) {
                return;
            }
            PluginImplementation annotation = possiblePlugin.getAnnotation(PluginImplementation.class);
            if (annotation == null) {
                return;
            }
            PluginClassMetaInformation preexistingMeta = pluginRegistry.getMetaInformationFor(possiblePlugin);
            if (preexistingMeta != null) {
                this.logger.info("Skipping plugin " + possiblePlugin + " because we already have it ");
                return;
            }
            PluginClassMetaInformation metaInformation = new PluginClassMetaInformation();
            metaInformation.pluginClassStatus = PluginClassMetaInformation.PluginClassStatus.ACCEPTED;
            metaInformation.pluginOrigin = location != null ? location.getToplevelLocation() : new URI("classpath://UNDEFINED");
            pluginRegistry.registerPluginClass(possiblePlugin, metaInformation);
            this.logger.finer("Updating cache information");
            if (pcu.getBoolean(possiblePlugin, "plugin.disabled", false) || possiblePlugin.getAnnotation(IsDisabled.class) != null) {
                metaInformation.pluginClassStatus = PluginClassMetaInformation.PluginClassStatus.DISABLED;
                this.logger.fine("Ignoring " + name + " due to request.");
                return;
            }
            String string = properties = possiblePlugin.getAnnotation(ConfigurationFile.class) != null ? possiblePlugin.getAnnotation(ConfigurationFile.class).file() : null;
            if (properties != null && properties.length() > 0) {
                String resourcePath = name.replaceAll("\\.", "/").replaceAll(possiblePlugin.getSimpleName(), "") + properties;
                this.logger.fine("Adding configuration from " + resourcePath + " for plugin " + name);
                Properties p = new Properties();
                try {
                    p.load(classPathManager.getResourceAsStream(location, resourcePath));
                    Set<Object> keys = p.keySet();
                    for (Object object : keys) {
                        if (pcu.getString(null, (String)object, new String[0]) == null) continue;
                        this.pluginManager.getPluginConfiguration().setConfiguration(null, (String)object, p.getProperty((String)object));
                    }
                }
                catch (IOException e) {
                    this.logger.warning("Unable to load properties " + resourcePath + " although requested");
                }
                catch (NullPointerException e) {
                    this.logger.warning("Unable to load properties " + resourcePath + " although requested. Probably not in package.");
                }
            }
            metaInformation.dependencies = spawner.getDependencies(possiblePlugin);
            metaInformation.pluginClassStatus = metaInformation.dependencies.size() == 0 ? PluginClassMetaInformation.PluginClassStatus.SPAWNABLE : PluginClassMetaInformation.PluginClassStatus.CONTAINS_UNRESOLVED_DEPENDENCIES;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.logger.warning("ClassNotFoundException. Unable to inspect class " + name + " although it appears to be one.");
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            this.logger.finer("Ignored class " + name + " due to unresolved dependencies");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.processPending();
    }

    protected void processPending() {
        boolean loopAgain;
        PluginRegistry pluginRegistry = this.pluginManager.getPluginRegistry();
        Spawner spawner = this.pluginManager.getSpawner();
        ArrayList<Class<? extends Plugin>> toSpawn = new ArrayList<Class<? extends Plugin>>();
        toSpawn.addAll(pluginRegistry.getPluginClassesWithStatus(PluginClassMetaInformation.PluginClassStatus.CONTAINS_UNRESOLVED_DEPENDENCIES));
        toSpawn.addAll(pluginRegistry.getPluginClassesWithStatus(PluginClassMetaInformation.PluginClassStatus.SPAWNABLE));
        if (toSpawn.size() == 0) {
            return;
        }
        do {
            ArrayList<Class> spawned = new ArrayList<Class>();
            loopAgain = false;
            for (Class clazz : toSpawn) {
                this.logger.fine("Trying to load pending " + clazz);
                PluginClassMetaInformation metaInformation = pluginRegistry.getMetaInformationFor(clazz);
                if (metaInformation.pluginClassStatus == PluginClassMetaInformation.PluginClassStatus.SPAWNABLE) {
                    this.logger.fine("Class found as SPAWNABLE. Trying to spawn it now " + clazz);
                    SpawnResult p = spawner.spawnPlugin(clazz);
                    if (p != null && p.metaInformation.pluginStatus != PluginMetaInformation.PluginStatus.FAILED) {
                        p.metaInformation.classMeta = metaInformation;
                        if (p.metaInformation.pluginStatus == PluginMetaInformation.PluginStatus.ACTIVE) {
                            metaInformation.pluginClassStatus = PluginClassMetaInformation.PluginClassStatus.SPAWNED;
                            spawned.add(clazz);
                            this.pluginManager.hookPlugin(p);
                        }
                        if (p.metaInformation.pluginStatus == PluginMetaInformation.PluginStatus.SPAWNED) {
                            metaInformation.pluginClassStatus = PluginClassMetaInformation.PluginClassStatus.LAZY_SPAWNED;
                            throw new IllegalStateException("Lazy spawning not supported yet!");
                        }
                        loopAgain = true;
                        break;
                    }
                    this.logger.warning("Failed to spawn class  " + clazz);
                    metaInformation.pluginClassStatus = PluginClassMetaInformation.PluginClassStatus.FAILED;
                }
                if (metaInformation.pluginClassStatus != PluginClassMetaInformation.PluginClassStatus.CONTAINS_UNRESOLVED_DEPENDENCIES) continue;
                this.logger.fine("Trying to solve dependencies for class " + clazz);
                boolean resolvedAll = true;
                for (PluginClassMetaInformation.Dependency d : metaInformation.dependencies) {
                    if (d.isOptional) {
                        this.logger.finest("Skipping dependency as optional " + d.pluginClass);
                        continue;
                    }
                    if (this.pluginManager.getPlugin(d.pluginClass, new OptionCapabilities(d.capabilites)) != null) continue;
                    resolvedAll = false;
                }
                if (!resolvedAll) continue;
                metaInformation.pluginClassStatus = PluginClassMetaInformation.PluginClassStatus.SPAWNABLE;
                loopAgain = true;
                break;
            }
            toSpawn.removeAll(spawned);
        } while (loopAgain && toSpawn.size() > 0);
    }
}

