/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.loader;

import java.net.URI;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.ClassPathManager;
import net.xeoh.plugins.base.impl.classpath.loader.AbstractLoader;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.ClassPathLocator;

public class InternalClasspathLoader
extends AbstractLoader {
    public InternalClasspathLoader(PluginManagerImpl pluginManager) {
        super(pluginManager);
    }

    @Override
    public boolean handlesURI(URI uri) {
        return uri.getScheme().equals("classpath");
    }

    @Override
    public void loadFrom(URI url) {
        if (url.toString().contains("*")) {
            if (url.toString().equals("classpath://*")) {
                this.loadAllClasspathPluginClasses(null);
            } else {
                String pattern = url.toString();
                pattern = pattern.replace("**", ".+");
                pattern = pattern.replace("*", "[^\\.]*");
                pattern = pattern.replace("classpath://", "");
                this.loadAllClasspathPluginClasses(pattern);
            }
            return;
        }
        if (url.toString().startsWith("classpath://")) {
            String toLoad = url.toString().substring("classpath://".length());
            try {
                this.loadClassFromClasspathByName(toLoad);
            }
            catch (OutOfMemoryError error) {
                this.logger.severe("Due to a bug (Issue #20), JSPF ran low on memory. Please increase your memory by (e.g., -Xmx1024m) or specify a 'classpath.filter.default.pattern' options. We hope to fix this bux in some future release. We are sorry for the inconvenience this might cause and we can understand if you hate us now :-(.");
                error.printStackTrace();
            }
            return;
        }
    }

    private void loadAllClasspathPluginClasses(String pattern) {
        this.logger.finer("Starting classpath search with pattern " + pattern);
        ClassPathManager manager = this.pluginManager.getClassPathManager();
        ClassPathLocator locator = manager.getLocator();
        Collection<AbstractClassPathLocation> locations = locator.findInCurrentClassPath();
        for (AbstractClassPathLocation location : locations) {
            manager.registerLocation(location);
            Collection<String> candidates = manager.findSubclassesFor(location, Plugin.class);
            this.logger.finer("Found " + candidates.size() + " candidates.");
            for (String string : candidates) {
                if (pattern == null) {
                    this.tryToLoadClassAsPlugin(location, string);
                    continue;
                }
                Pattern p = Pattern.compile(pattern);
                Matcher m = p.matcher(string);
                this.logger.finest(string + " " + m.matches());
                if (!m.matches()) continue;
                this.tryToLoadClassAsPlugin(location, string);
            }
        }
    }

    private void loadClassFromClasspathByName(String toLoad) {
        this.logger.fine("Loading " + toLoad + " directly");
        this.tryToLoadClassAsPlugin(null, toLoad);
    }
}

