/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.locator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import net.jcores.CoreKeeper;
import net.jcores.options.Option;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.util.PluginConfigurationUtil;

public class ClassPathLocator {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private final JARCache cache;
    private PluginManagerImpl pluginManager;

    public ClassPathLocator(PluginManagerImpl pluginManager, JARCache cache) {
        this.pluginManager = pluginManager;
        this.cache = cache;
    }

    public Collection<AbstractClassPathLocation> findBelow(URI toplevel) {
        ArrayList<AbstractClassPathLocation> rval = new ArrayList<AbstractClassPathLocation>();
        File startPoint = new File(toplevel);
        if (CoreKeeper.$(startPoint).filter(".*\\.plugin?$", new Option[0]).get(false) != null) {
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, toplevel.toString(), toplevel));
            return rval;
        }
        if (startPoint.isDirectory()) {
            File[] listFiles = startPoint.listFiles();
            boolean hasJARs = false;
            for (File file : listFiles) {
                if (file.getAbsolutePath().endsWith(".jar")) {
                    rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, file.toURI().toString(), file.toURI()));
                    hasJARs = true;
                }
                if (CoreKeeper.$(file).filter(".*\\.plugin?$", new Option[0]).get(false) == null) continue;
                rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, file.toURI().toString(), file.toURI()));
                hasJARs = true;
            }
            if (hasJARs) {
                return rval;
            }
            if (toplevel.toString().contains("/bin/") || toplevel.toString().contains("class")) {
                this.logger.warning("Adding plugins in 'raw' classpaths, such as 'bin/' or 'classes/' is not recommended. Please use classpath://* instead (the video is a bit outdated in this respect).");
            }
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, toplevel.toString(), toplevel));
            return rval;
        }
        if (startPoint.isFile() && startPoint.getAbsolutePath().endsWith(".jar")) {
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, toplevel.toString(), toplevel));
            return rval;
        }
        return rval;
    }

    public Collection<AbstractClassPathLocation> findInCurrentClassPath() {
        ArrayList<AbstractClassPathLocation> rval = new ArrayList<AbstractClassPathLocation>();
        boolean filter = new PluginConfigurationUtil(this.pluginManager.getPluginConfiguration()).getBoolean(PluginManager.class, "classpath.filter.default.enabled", true);
        String[] blacklist = new PluginConfigurationUtil(this.pluginManager.getPluginConfiguration()).getString(PluginManager.class, "classpath.filter.default.pattern", "/jre/lib/;/jdk/lib/;/lib/rt.jar").split(";");
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        String[] split = classpath.split(pathSep);
        ArrayList<URL> toFilter = new ArrayList<URL>();
        this.logger.fine("Finding classes in current classpath (using separator '" + pathSep + "'): " + classpath);
        if (filter) {
            ClassLoader loader;
            this.logger.finer("Filtering default classpaths by request.");
            for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
            }
            if (loader != null && loader instanceof URLClassLoader) {
                URL[] urls;
                for (URL url : urls = ((URLClassLoader)loader).getURLs()) {
                    this.logger.finer("Putting '" + url + "' on our filterlist.");
                    toFilter.add(url);
                }
            }
            for (String item : blacklist) {
                this.logger.finer("Blacklist entry: " + item);
            }
        }
        for (String string : split) {
            try {
                URL url = new File(string).toURI().toURL();
                this.logger.fine("Trying to add '" + string + "' to our classpath location.");
                this.logger.fine("Converted to " + url);
                if (toFilter.contains(url) || this.blacklisted(blacklist, url)) {
                    this.logger.fine("But it was filtered because it was in our list or blacklisted.");
                    continue;
                }
                rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, "#classpath", new File(string).toURI()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return rval;
    }

    private boolean blacklisted(String[] blacklist, URL url) {
        if (blacklist == null || blacklist.length == 0 || blacklist[0].length() == 0) {
            return false;
        }
        for (String string : blacklist) {
            if (!url.toString().contains(string)) continue;
            return true;
        }
        return false;
    }
}

