/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.locator.locations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.jcores.CoreKeeper;
import net.jcores.options.Option;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.locations.JARClasspathLocation;

public class MultiPluginClasspathLocation
extends AbstractClassPathLocation {
    final Map<String, String> entryMapping = new HashMap<String, String>();
    final Collection<String> allJARs;

    public MultiPluginClasspathLocation(JARCache cache, String realm, URI location) {
        super(cache, realm, location);
        this.allJARs = CoreKeeper.$(location).file().dir(new Option[0]).filter(".*jar$", new Option[0]).string().list();
    }

    @Override
    public AbstractClassPathLocation.LocationType getType() {
        return AbstractClassPathLocation.LocationType.MULTI_PLUGIN;
    }

    @Override
    public URI[] getClasspathLocations() {
        return CoreKeeper.$(this.allJARs).string().file().uri().array(URI.class);
    }

    @Override
    public InputStream getInputStream(String file) {
        String uri = this.entryMapping.get(file);
        if (uri == null) {
            return null;
        }
        try {
            JarURLConnection connection = (JarURLConnection)new URI("jar:" + new File(uri).toURI() + "!/").toURL().openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).equals(file)) continue;
                return jarFile.getInputStream(entry);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Collection<String> listAllEntries() {
        ArrayList<String> rval = new ArrayList<String>();
        for (String entry : this.allJARs) {
            Collection<String> all = JARClasspathLocation.listAllEntriesFor(URI.create(entry));
            for (String string : all) {
                this.entryMapping.put(string, entry);
            }
            rval.addAll(all);
        }
        return rval;
    }

    @Override
    public Collection<String> listToplevelClassNames() {
        ArrayList<String> rval = new ArrayList<String>();
        for (String entry : this.allJARs) {
            Collection<String> all = JARClasspathLocation.listToplevelClassNamesForURI(new File(entry).toURI());
            for (String string : all) {
                this.entryMapping.put(string, entry);
            }
            rval.addAll(all);
        }
        return rval;
    }
}

