/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.spawning;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TimerTask;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.annotations.Thread;
import net.xeoh.plugins.base.annotations.Timer;
import net.xeoh.plugins.base.annotations.events.Init;
import net.xeoh.plugins.base.annotations.events.PluginLoaded;
import net.xeoh.plugins.base.annotations.events.Shutdown;
import net.xeoh.plugins.base.annotations.injections.InjectPlugin;
import net.xeoh.plugins.base.diagnosis.channels.tracing.SpawnerTracer;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.registry.PluginClassMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluginMetaInformation;
import net.xeoh.plugins.base.impl.spawning.SpawnResult;
import net.xeoh.plugins.base.impl.spawning.handler.InjectHandler;
import net.xeoh.plugins.base.util.PluginManagerUtil;
import net.xeoh.plugins.diagnosis.local.Diagnosis;
import net.xeoh.plugins.diagnosis.local.DiagnosisChannel;
import net.xeoh.plugins.diagnosis.local.options.ChannelOption;
import net.xeoh.plugins.diagnosis.local.options.StatusOption;
import net.xeoh.plugins.diagnosis.local.options.status.OptionInfo;

public class Spawner {
    DiagnosisChannel<String> diagnosis;
    private final PluginManagerImpl pluginManager;

    public Spawner(PluginManagerImpl pmi) {
        this.pluginManager = pmi;
    }

    public void destroyPlugin(Plugin plugin, PluginMetaInformation metaInformation) {
        this.log("destroy/start", new OptionInfo("plugin", (Serializable)((Object)plugin.getClass().getCanonicalName())));
        for (TimerTask timerTask : metaInformation.timerTasks) {
            timerTask.cancel();
        }
        for (java.util.Timer timer : metaInformation.timers) {
            timer.cancel();
        }
        for (java.lang.Thread thread : metaInformation.threads) {
            try {
                thread.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.callShutdownMethods(plugin);
        this.log("destroy/end", new OptionInfo("plugin", (Serializable)((Object)plugin.getClass().getCanonicalName())));
    }

    public void processThisPluginLoadedAnnotation(Plugin plugin, PluginMetaInformation metaInformation) {
        for (PluginMetaInformation.PluginLoadedInformation pli : metaInformation.pluginLoadedInformation) {
            Collection<? extends Plugin> plugins = new PluginManagerUtil(this.pluginManager).getPlugins(pli.baseType);
            for (Plugin plugin2 : plugins) {
                try {
                    pli.method.invoke((Object)plugin, plugin2);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            pli.calledWith.addAll(plugins);
        }
    }

    public void processOtherPluginLoadedAnnotation(Plugin newPlugin) {
        for (Plugin plugin : this.pluginManager.getPluginRegistry().getAllPlugins()) {
            PluginMetaInformation pmi = this.pluginManager.getPluginRegistry().getMetaInformationFor(plugin);
            for (PluginMetaInformation.PluginLoadedInformation pli : pmi.pluginLoadedInformation) {
                Collection<? extends Plugin> plins = new PluginManagerUtil(this.pluginManager).getPlugins(pli.baseType);
                if (!plins.contains(newPlugin)) continue;
                try {
                    pli.method.invoke((Object)plugin, newPlugin);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                pli.calledWith.add(newPlugin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SpawnResult spawnPlugin(final Class c) {
        Method[] methods;
        SpawnResult spawnResult;
        java.util.Timer timer;
        long startTime;
        block10: {
            this.log("spawn/start", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())));
            startTime = System.nanoTime();
            timer = new java.util.Timer();
            TimerTask lateMessage = new TimerTask(){

                @Override
                public void run() {
                    Spawner.this.log("spawn/timeout/toolong", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())));
                }
            };
            timer.schedule(lateMessage, 250L);
            Plugin spawnedPlugin = (Plugin)c.newInstance();
            spawnResult = new SpawnResult(spawnedPlugin);
            spawnResult.metaInformation.pluginStatus = PluginMetaInformation.PluginStatus.SPAWNED;
            spawnResult.metaInformation.spawnTime = System.currentTimeMillis();
            new InjectHandler(this.pluginManager).init(spawnedPlugin);
            methods = this.getMethods(c);
            boolean initStatus = this.callInitMethods(spawnedPlugin, methods);
            if (initStatus) break block10;
            spawnResult.metaInformation.pluginStatus = PluginMetaInformation.PluginStatus.FAILED;
            SpawnResult spawnResult2 = spawnResult;
            timer.cancel();
            long stopTime = System.nanoTime();
            long delta = (stopTime - startTime) / 1000L;
            this.log("spawn/duration", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())), new OptionInfo("time", (Serializable)((Object)("" + delta))));
            return spawnResult2;
        }
        spawnResult.metaInformation.pluginStatus = PluginMetaInformation.PluginStatus.INITIALIZED;
        this.spawnThreads(spawnResult, methods);
        this.spawnTimer(spawnResult, methods);
        this.obtainPluginLoadedMethods(spawnResult, methods);
        spawnResult.metaInformation.pluginStatus = PluginMetaInformation.PluginStatus.ACTIVE;
        this.log("spawn/end", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())));
        SpawnResult spawnResult3 = spawnResult;
        timer.cancel();
        long stopTime = System.nanoTime();
        long delta = (stopTime - startTime) / 1000L;
        this.log("spawn/duration", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())), new OptionInfo("time", (Serializable)((Object)("" + delta))));
        return spawnResult3;
        {
            catch (Throwable e2222) {
                SpawnResult e2222;
                try {
                    this.log("spawn/exception/init", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())));
                    e2222.printStackTrace();
                    for (Throwable cause = e2222.getCause(); cause != null; cause = cause.getCause()) {
                        cause.printStackTrace();
                    }
                    e2222 = null;
                    timer.cancel();
                }
                catch (Throwable e3) {
                    try {
                        this.log("spawn/exception/construct", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())));
                        e3.printStackTrace();
                        for (Throwable cause = e3.getCause(); cause != null; cause = cause.getCause()) {
                            cause.printStackTrace();
                        }
                        timer.cancel();
                    }
                    catch (Throwable throwable) {
                        timer.cancel();
                        long stopTime2 = System.nanoTime();
                        long delta2 = (stopTime2 - startTime) / 1000L;
                        this.log("spawn/duration", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())), new OptionInfo("time", (Serializable)((Object)("" + delta2))));
                        throw throwable;
                    }
                    long stopTime3 = System.nanoTime();
                    long delta3 = (stopTime3 - startTime) / 1000L;
                    this.log("spawn/duration", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())), new OptionInfo("time", (Serializable)((Object)("" + delta3))));
                }
                long stopTime4 = System.nanoTime();
                long delta4 = (stopTime4 - startTime) / 1000L;
                this.log("spawn/duration", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())), new OptionInfo("time", (Serializable)((Object)("" + delta4))));
                return e2222;
            }
        }
        this.log("spawn/end/abnormal", new OptionInfo("plugin", (Serializable)((Object)c.getCanonicalName())));
        return null;
    }

    private boolean callInitMethods(Plugin spawnedPlugin, Method[] methods) throws IllegalAccessException {
        this.log("callinit/start", new OptionInfo("plugin", (Serializable)((Object)spawnedPlugin.getClass().getCanonicalName())));
        for (Method method : methods) {
            this.log("callinit/method", new OptionInfo("method", (Serializable)((Object)method.getName())));
            Init annotation = method.getAnnotation(Init.class);
            if (annotation == null) continue;
            this.log("callinit/method/initannotation", new OptionInfo("method", (Serializable)((Object)method.getName())));
            try {
                Object invoke = method.invoke((Object)spawnedPlugin, new Object[0]);
                if (invoke == null || !(invoke instanceof Boolean) || ((Boolean)invoke).booleanValue()) continue;
                return false;
            }
            catch (IllegalArgumentException e) {
                this.log("callinit/exception/illegalargument", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                this.log("callinit/end/abnormal", new OptionInfo("plugin", (Serializable)((Object)spawnedPlugin.getClass().getCanonicalName())));
                e.printStackTrace();
                return false;
            }
            catch (InvocationTargetException e) {
                this.log("callinit/exception/invocationtargetexception", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                this.log("callinit/end/abnormal", new OptionInfo("plugin", (Serializable)((Object)spawnedPlugin.getClass().getCanonicalName())));
                e.printStackTrace();
                return false;
            }
            catch (Exception e) {
                this.log("callinit/exception/exception", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                this.log("callinit/end/abnormal", new OptionInfo("plugin", (Serializable)((Object)spawnedPlugin.getClass().getCanonicalName())));
                e.printStackTrace();
                return false;
            }
        }
        this.log("callinit/end", new OptionInfo("plugin", (Serializable)((Object)spawnedPlugin.getClass().getCanonicalName())));
        return true;
    }

    private void callShutdownMethods(Plugin plugin) {
        Method[] methods;
        this.log("callshutdown/start", new OptionInfo("plugin", (Serializable)((Object)plugin.getClass().getCanonicalName())));
        Class<?> spawnClass = plugin.getClass();
        for (Method method : methods = spawnClass.getMethods()) {
            this.log("callshutdown/method", new OptionInfo("method", (Serializable)((Object)method.getName())));
            Shutdown annotation = method.getAnnotation(Shutdown.class);
            if (annotation == null) continue;
            this.log("callshutdown/method/shutdownannotation", new OptionInfo("method", (Serializable)((Object)method.getName())));
            try {
                method.invoke((Object)plugin, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                this.log("callshutdown/exception/illegalargument", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.log("callinit/exception/invocationtargetexception", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                e.printStackTrace();
            }
            catch (Exception e) {
                this.log("callshutdown/exception/exception", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                e.printStackTrace();
            }
        }
        this.log("callshutdown/end", new OptionInfo("plugin", (Serializable)((Object)plugin.getClass().getCanonicalName())));
    }

    private Method[] getMethods(Class<? extends Plugin> c) {
        Method[] methods = c.getMethods();
        return methods;
    }

    private void spawnThreads(final SpawnResult spawnResult, Method[] methods) {
        this.log("spawnthreads/start", new OptionInfo("plugin", (Serializable)((Object)spawnResult.plugin.getClass().getCanonicalName())));
        for (final Method method : methods) {
            method.setAccessible(true);
            Thread annotation = method.getAnnotation(Thread.class);
            if (annotation == null) continue;
            java.lang.Thread t = new java.lang.Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        method.invoke((Object)spawnResult.plugin, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        Spawner.this.log("spawnthreads/exception/illegalargument", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        Spawner.this.log("spawnthreads/exception/illegalaccess", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        Spawner.this.log("spawnthreads/exception/invocationtargetexception", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                        e.printStackTrace();
                    }
                }
            });
            String name = spawnResult.plugin.getClass().getName() + "." + method.getName() + "()";
            this.log("spawnthreads/threadstart", new OptionInfo("plugin", (Serializable)((Object)spawnResult.plugin.getClass().getCanonicalName())), new OptionInfo("threadname", (Serializable)((Object)name)));
            t.setName(name);
            t.setDaemon(annotation.isDaemonic());
            t.start();
            spawnResult.metaInformation.threads.add(t);
        }
        this.log("spawnthreads/end", new OptionInfo("plugin", (Serializable)((Object)spawnResult.plugin.getClass().getCanonicalName())));
    }

    private void obtainPluginLoadedMethods(SpawnResult spawnResult, Method[] methods) {
        for (Method method : methods) {
            method.setAccessible(true);
            PluginLoaded annotation = method.getAnnotation(PluginLoaded.class);
            if (annotation == null) continue;
            PluginMetaInformation.PluginLoadedInformation pli = new PluginMetaInformation.PluginLoadedInformation();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                this.log("pluginloadedmethods/wrongnumberofparams", new OptionInfo("plugin", (Serializable)((Object)spawnResult.plugin.getClass().getCanonicalName())), new OptionInfo("method", (Serializable)((Object)method.getName())));
                continue;
            }
            pli.method = method;
            pli.baseType = parameterTypes[0];
            spawnResult.metaInformation.pluginLoadedInformation.add(pli);
        }
    }

    private void spawnTimer(final SpawnResult spawnResult, Method[] methods) {
        this.log("spawntimers/start", new OptionInfo("plugin", (Serializable)((Object)spawnResult.plugin.getClass().getCanonicalName())));
        for (final Method method : methods) {
            method.setAccessible(true);
            Timer annotation = method.getAnnotation(Timer.class);
            if (annotation == null) continue;
            final java.util.Timer t = new java.util.Timer();
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Object invoke = method.invoke((Object)spawnResult.plugin, new Object[0]);
                        if (invoke != null && invoke instanceof Boolean && ((Boolean)invoke).booleanValue()) {
                            t.cancel();
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Spawner.this.log("spawntimers/exception/illegalargument", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        Spawner.this.log("spawntimers/exception/illegalaccessexception", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        Spawner.this.log("spawntimers/exception/invocationtargetexception", new OptionInfo("method", (Serializable)((Object)method.getName())), new OptionInfo("message", (Serializable)((Object)e.getMessage())));
                        e.printStackTrace();
                    }
                }
            };
            if (annotation.timerType() == Timer.TimerType.RATE_BASED) {
                t.scheduleAtFixedRate(tt, annotation.startupDelay(), annotation.period());
            }
            if (annotation.timerType() == Timer.TimerType.DELAY_BASED) {
                t.schedule(tt, annotation.startupDelay(), annotation.period());
            }
            spawnResult.metaInformation.timerTasks.add(tt);
            spawnResult.metaInformation.timers.add(t);
        }
        this.log("spawntimers/end", new OptionInfo("plugin", (Serializable)((Object)spawnResult.plugin.getClass().getCanonicalName())));
    }

    public Collection<PluginClassMetaInformation.Dependency> getDependencies(Class<? extends Plugin> pluginClass) {
        Field[] fields;
        ArrayList<PluginClassMetaInformation.Dependency> rval = new ArrayList<PluginClassMetaInformation.Dependency>();
        for (Field field : fields = pluginClass.getFields()) {
            field.setAccessible(true);
            InjectPlugin ipannotation = field.getAnnotation(InjectPlugin.class);
            if (ipannotation == null || ipannotation.isOptional()) continue;
            PluginClassMetaInformation.Dependency d = new PluginClassMetaInformation.Dependency();
            d.capabilites = ipannotation.requiredCapabilities();
            d.pluginClass = field.getType();
            d.isOptional = ipannotation.isOptional();
            rval.add(d);
        }
        return rval;
    }

    void log(String message, StatusOption ... options) {
        if (this.diagnosis == null) {
            Diagnosis diag = this.pluginManager.getDiagnosis();
            if (diag == null) {
                return;
            }
            this.diagnosis = diag.channel(SpawnerTracer.class, new ChannelOption[0]);
        }
        this.diagnosis.status(message, options);
    }
}

