/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.spawning.handler;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.annotations.injections.InjectPlugin;
import net.xeoh.plugins.base.impl.spawning.handler.AbstractHandler;
import net.xeoh.plugins.base.options.getplugin.OptionCapabilities;

public class InjectHandler
extends AbstractHandler {
    public InjectHandler(PluginManager pluginManager) {
        super(pluginManager);
    }

    @Override
    public void init(Plugin plugin) throws Exception {
        String[] capabilities;
        InjectPlugin ipannotation;
        Field[] fields = plugin.getClass().getFields();
        Method[] methods = plugin.getClass().getMethods();
        for (Field field : fields) {
            field.setAccessible(true);
            ipannotation = field.getAnnotation(InjectPlugin.class);
            if (ipannotation == null) continue;
            capabilities = ipannotation.requiredCapabilities();
            Class<?> typeOfField = field.getType();
            this.logger.fine("Injecting plugin by autodetection (" + typeOfField.getName() + ") into " + plugin.getClass().getName());
            field.set(plugin, this.pluginManager.getPlugin(typeOfField, new OptionCapabilities(capabilities)));
        }
        for (AccessibleObject accessibleObject : methods) {
            ((Method)accessibleObject).setAccessible(true);
            ipannotation = ((Method)accessibleObject).getAnnotation(InjectPlugin.class);
            if (ipannotation == null) continue;
            capabilities = ipannotation.requiredCapabilities();
            Class<?> typeOfMethod = ((Method)accessibleObject).getParameterTypes()[0];
            this.logger.fine("Injecting plugin by autodetection (" + typeOfMethod.getName() + ") into " + plugin.getClass().getName());
            try {
                ((Method)accessibleObject).invoke(plugin, this.pluginManager.getPlugin(typeOfMethod, new OptionCapabilities(capabilities)));
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Unable to inject plugin " + typeOfMethod + " into method " + accessibleObject);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.logger.warning("Unable to inject plugin " + typeOfMethod + " into method " + accessibleObject);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deinit(Plugin plugin) throws Exception {
    }
}

