/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.util;

import java.util.ArrayList;
import java.util.Collection;
import net.xeoh.plugins.base.Option;
import net.xeoh.plugins.base.util.OptionHandler;

public class OptionUtils<T extends Option> {
    private T[] options;

    public OptionUtils(T ... options) {
        this.options = options;
    }

    public boolean contains(Class<? extends T> option) {
        for (T t : this.options) {
            if (t == null || !option.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Class<? extends T> ... option) {
        for (T t : this.options) {
            if (t == null) continue;
            for (Class<T> clazz : option) {
                if (!clazz.isAssignableFrom(t.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public <O extends T> O get(Class<? extends O> option, O ... deflt) {
        for (T t : this.options) {
            if (t == null || !option.isAssignableFrom(t.getClass())) continue;
            return (O)t;
        }
        if (deflt.length > 0) {
            return deflt[0];
        }
        return null;
    }

    public <O extends T> Collection<O> getAll(Class<? extends O> option) {
        ArrayList<T> rval = new ArrayList<T>();
        for (T t : this.options) {
            if (t == null || !option.isAssignableFrom(t.getClass())) continue;
            rval.add(t);
        }
        return rval;
    }

    public <O extends T> void handle(Class<? extends O> option, OptionHandler<O> handler) {
        for (T t : this.options) {
            if (t == null || !option.isAssignableFrom(t.getClass())) continue;
            handler.handle(t);
        }
    }
}

