/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import net.xeoh.plugins.base.options.GetPluginOption;
import net.xeoh.plugins.base.options.getplugin.OptionPluginSelector;
import net.xeoh.plugins.base.options.getplugin.PluginSelector;

public class PluginManagerUtil
implements PluginManager {
    private final PluginManager pluginManager;

    public PluginManagerUtil(PluginManager pm) {
        this.pluginManager = pm;
    }

    public <P extends Plugin> Collection<P> getPlugins(Class<P> plugin) {
        return this.getPlugins(plugin, new PluginSelector<P>(){

            @Override
            public boolean selectPlugin(P p) {
                return true;
            }
        });
    }

    public <P extends Plugin> Collection<P> getPlugins(Class<P> plugin, final PluginSelector<P> selector) {
        final ArrayList allPlugins = new ArrayList();
        this.pluginManager.getPlugin(plugin, new OptionPluginSelector(new PluginSelector<P>(){

            @Override
            public boolean selectPlugin(P p) {
                if (selector.selectPlugin(p)) {
                    allPlugins.add(p);
                }
                return false;
            }
        }));
        return allPlugins;
    }

    @Override
    public void addPluginsFrom(URI url, AddPluginsFromOption ... options) {
        this.pluginManager.addPluginsFrom(url, options);
    }

    @Override
    public <P extends Plugin> P getPlugin(Class<P> plugin, GetPluginOption ... options) {
        return this.pluginManager.getPlugin(plugin, options);
    }

    @Override
    public void shutdown() {
        this.pluginManager.shutdown();
    }
}

