/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.xeoh.plugins.base.Plugin;

public class PluginUtil {
    final Plugin plugin;

    public PluginUtil(Plugin plugin) {
        this.plugin = plugin;
    }

    public Collection<Class<? extends Plugin>> getPrimaryInterfaces() {
        Collection<Class<? extends Plugin>> rval = this.getPluginInterfaces();
        ArrayList<Object> candidates = new ArrayList();
        int lastSize = 0;
        do {
            lastSize = rval.size();
            candidates = new ArrayList<Class<? extends Plugin>>(rval);
            rval.clear();
            for (Class clazz : candidates) {
                boolean hasSuper = false;
                for (Class clazz2 : candidates) {
                    if (!clazz.isAssignableFrom(clazz2) || clazz == clazz2) continue;
                    hasSuper = true;
                }
                if (hasSuper || rval.contains(clazz)) continue;
                rval.add(clazz);
            }
        } while (lastSize != rval.size());
        return rval;
    }

    public Collection<Class<? extends Plugin>> getPluginInterfaces() {
        ArrayList<Class<? extends Plugin>> rval = new ArrayList<Class<? extends Plugin>>();
        ArrayList candidates = new ArrayList();
        for (Class<?> current = this.plugin.getClass(); current != null && !Object.class.equals(current); current = current.getSuperclass()) {
            List<Class<?>> c = Arrays.asList(current.getInterfaces());
            for (Class<?> class1 : c) {
                if (candidates.contains(class1)) continue;
                candidates.add(class1);
            }
        }
        for (Class clazz : candidates) {
            if (!Plugin.class.isAssignableFrom(clazz)) continue;
            rval.add(clazz);
        }
        return rval;
    }

    public Collection<Class<? extends Plugin>> getAllPluginInterfaces() {
        Collection<Class<? extends Plugin>> pluginInterfaces = this.getPluginInterfaces();
        ArrayList<Class<? extends Plugin>> rval = new ArrayList<Class<? extends Plugin>>();
        ArrayList<Class<? extends Plugin>> x = new ArrayList<Class<? extends Plugin>>(pluginInterfaces);
        while (x.size() > 0) {
            Class<?>[] interfaces;
            Class<? extends Plugin> c = x.get(0);
            x.remove(0);
            if (!rval.contains(c)) {
                rval.add(c);
            }
            for (Class<?> class1 : interfaces = c.getInterfaces()) {
                if (x.contains(class1)) continue;
                x.add(class1);
            }
        }
        return rval;
    }
}

