/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.diagnosis.local.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcores.CoreKeeper;
import net.xeoh.plugins.base.PluginConfiguration;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.events.Shutdown;
import net.xeoh.plugins.base.util.PluginConfigurationUtil;
import net.xeoh.plugins.diagnosis.local.Diagnosis;
import net.xeoh.plugins.diagnosis.local.DiagnosisChannel;
import net.xeoh.plugins.diagnosis.local.DiagnosisChannelID;
import net.xeoh.plugins.diagnosis.local.DiagnosisMonitor;
import net.xeoh.plugins.diagnosis.local.DiagnosisStatus;
import net.xeoh.plugins.diagnosis.local.impl.DiagnosisChannelDummyImpl;
import net.xeoh.plugins.diagnosis.local.impl.DiagnosisChannelImpl;
import net.xeoh.plugins.diagnosis.local.impl.DiagnosisStatusImpl;
import net.xeoh.plugins.diagnosis.local.impl.serialization.java.Entry;
import net.xeoh.plugins.diagnosis.local.impl.serialization.java.EntryCallback;
import net.xeoh.plugins.diagnosis.local.impl.serialization.java.LogFileReader;
import net.xeoh.plugins.diagnosis.local.impl.serialization.java.LogFileWriter;
import net.xeoh.plugins.diagnosis.local.options.ChannelOption;
import net.xeoh.plugins.diagnosis.local.options.status.OptionInfo;

@PluginImplementation
public class DiagnosisImpl
implements Diagnosis {
    final Map<Class<? extends DiagnosisChannelID<?>>, KeyEntry> items = new ConcurrentHashMap();
    public PluginConfiguration configuration;
    boolean isDisabled = false;
    boolean useStackTraces = false;
    boolean compressOutput = true;
    int stackTracesDepth = 1;
    String recordingFile = null;
    volatile LogFileWriter serializer = null;
    boolean recordingEnabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> DiagnosisChannel<T> channel(Class<? extends DiagnosisChannelID<T>> channel, ChannelOption ... options) {
        if (this.isDisabled) {
            DiagnosisChannelDummyImpl impl = new DiagnosisChannelDummyImpl(this, channel);
            return impl;
        }
        Object impl = this;
        synchronized (impl) {
            if (this.serializer == null && this.recordingEnabled) {
                this.serializer = this.createWriter();
            }
        }
        impl = new DiagnosisChannelImpl(this, channel);
        return impl;
    }

    LogFileWriter createWriter() {
        try {
            return new LogFileWriter(this.recordingFile, this.compressOutput);
        }
        catch (Exception e) {
            try {
                return new LogFileWriter(this.recordingFile + "." + System.currentTimeMillis(), this.compressOutput);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEntry(DiagnosisStatus<?> status, Entry entry) {
        if (this.serializer != null) {
            this.serializer.record(entry);
        }
        KeyEntry keyEntry = this.getKeyEntry(status.getChannel());
        try {
            keyEntry.entryLock.lock();
            keyEntry.lastItem = status;
            for (DiagnosisMonitor<?> listener : keyEntry.allListeners) {
                try {
                    listener.onStatusChange(status);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            keyEntry.entryLock.unlock();
        }
    }

    public void init() {
        PluginConfigurationUtil util = new PluginConfigurationUtil(this.configuration);
        this.isDisabled = !util.getBoolean(Diagnosis.class, "general.enabled", true);
        this.recordingEnabled = util.getBoolean(Diagnosis.class, "recording.enabled", false);
        this.recordingFile = util.getString(Diagnosis.class, "recording.file", "diagnosis.record");
        this.useStackTraces = util.getBoolean(Diagnosis.class, "analysis.stacktraces.enabled", false);
        this.stackTracesDepth = util.getInt(Diagnosis.class, "analysis.stacktraces.depth", 1);
        String mode = util.getString(Diagnosis.class, "recording.format", "java/serialization/gzip");
        if ("java/serialization/gzip".equals(mode)) {
            this.compressOutput = true;
        }
        if ("java/serialization".equals(mode)) {
            this.compressOutput = false;
        }
    }

    @Shutdown
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> void registerMonitor(Class<? extends DiagnosisChannelID<T>> channel, DiagnosisMonitor<T> listener) {
        if (channel == null || listener == null) {
            return;
        }
        KeyEntry keyEntry = this.getKeyEntry(channel);
        try {
            keyEntry.entryLock.lock();
            if (keyEntry.lastItem != null) {
                try {
                    listener.onStatusChange(keyEntry.lastItem);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            keyEntry.allListeners.add(listener);
        }
        finally {
            keyEntry.entryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyEntry getKeyEntry(Class<? extends DiagnosisChannelID<?>> id) {
        KeyEntry keyEntry = null;
        Map<Class<? extends DiagnosisChannelID<?>>, KeyEntry> map = this.items;
        synchronized (map) {
            keyEntry = this.items.get(id);
            if (keyEntry == null) {
                keyEntry = new KeyEntry();
                this.items.put(id, keyEntry);
            }
        }
        return keyEntry;
    }

    @Override
    public void replay(String file, final DiagnosisMonitor<?> listener) {
        LogFileReader reader = new LogFileReader(file);
        reader.replay(new EntryCallback(){

            @Override
            public void nextEntry(Entry entry) {
                ArrayList<OptionInfo> infos = new ArrayList<OptionInfo>();
                for (String value : entry.additionalInfo.keySet()) {
                    infos.add(new OptionInfo(value, (Serializable)entry.additionalInfo.get(value)));
                }
                DiagnosisStatusImpl<Serializable> event = new DiagnosisStatusImpl<Serializable>(entry.channel, (Serializable)entry.value, entry.date, CoreKeeper.$(infos).array(OptionInfo.class));
                listener.onStatusChange(event);
            }
        });
    }

    class KeyEntry {
        final Lock entryLock = new ReentrantLock();
        final Collection<DiagnosisMonitor<?>> allListeners = new ArrayList();
        DiagnosisStatus<?> lastItem = null;

        KeyEntry() {
        }
    }
}

