uniform sampler3D volume_texture;
uniform sampler3D normal_texture;
uniform mat3 normal_transform;

void lighting(
		in int i,
		in vec3 normal, 
		inout vec3 ambient, 
		inout vec3 diffuse,
		inout vec3 specular)
{
    // Normalized light direction and half vector
    vec3 lightDirection = normalize(vec3(gl_LightSource[i].position));
    vec3 halfVector     = normalize(vec3(gl_LightSource[i].halfVector));
    
    float nDotVP; // normal . light_direction
    float nDotHV; // normal . light_half_vector
    float pf; // power factor
    
    nDotVP = max(0.0, dot(normal, lightDirection));
    nDotHV = max(0.0, dot(normal, halfVector));
    
    if (nDotVP == 0.0) {
        pf = 0.0;
    } else {
        pf = pow(nDotHV, gl_FrontMaterial.shininess);
    }
    
    ambient  += gl_LightSource[i].ambient;
    diffuse  += gl_LightSource[i].diffuse * nDotVP;
    specular += gl_LightSource[i].specular * pf;
	
}

void main(void)
{
    vec4 orig_color  = texture3D(volume_texture, vec3(gl_TexCoord[0]));
    vec3 encoded_normal = texture3D(normal_texture, vec3(gl_TexCoord[0]));
    vec3 object_normal    = 2.0*encoded_normal - vec3(1.0, 1.0, 1.0);
    vec3 normal = -normalize( normal_transform * object_normal );
    
    vec3 ambient, diffuse, specular;
    //for(int i=0; i<gl_MaxLights; ++i) 
    lighting(0, normal, ambient, diffuse, specular);
    //lighting(1, normal, ambient, diffuse, specular);
    ambient *= orig_color;
    diffuse *= orig_color;
    vec3 color = ambient + diffuse + specular;
   	
    gl_FragColor = vec4(color, orig_color.a) * gl_Color;

}
